<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormColumnValue extends Model 
{

    protected $table = 'form_column_values';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('form_column_id', 'multiple_per_row');

    public function formColumn()
    {
        return $this->belongsTo('FormColumn');
    }

    public function formDataType()
    {
        return $this->belongsTo('FormDataType');
    }

}